<?php
/**
 * Frontend template
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="ai-hair-simulator-container" id="ai-hair-simulator">
    <div class="ai-hair-simulator-loading" id="ai-hair-simulator-loading" style="display: none;">
        <div class="loading-content">
            <div class="spinner"></div>
            <h3 id="loading-title"><?php _e('Processing...', 'ai-hair-simulator'); ?></h3>
            <p id="loading-message"><?php _e('AI is working its magic', 'ai-hair-simulator'); ?></p>
        </div>
    </div>

    <div class="ai-hair-simulator-upload" id="ai-hair-simulator-upload">
        <h2 class="simulator-title"><?php echo esc_html($atts['title']); ?></h2>

        <div class="error-message" id="error-message" style="display: none;"></div>

        <div class="ai-hair-simulator-user-info">
            <h3 class="user-info-title"><?php _e('Tell us a bit about you', 'ai-hair-simulator'); ?></h3>

            <div class="ai-hair-simulator-fields-grid">
                <div class="ai-hair-simulator-field">
                    <label for="aihs-full-name" class="user-info-label">
                        <?php _e('Full Name', 'ai-hair-simulator'); ?> <span class="required">*</span>
                    </label>
                    <input type="text" id="aihs-full-name" class="user-info-input" required />
                </div>

                <div class="ai-hair-simulator-field">
                    <label for="aihs-email" class="user-info-label">
                        <?php _e('Email', 'ai-hair-simulator'); ?> <span class="required">*</span>
                    </label>
                    <input type="email" id="aihs-email" class="user-info-input" required />
                </div>

                <?php if (get_option('ai_hair_simulator_show_phone', 1)) : ?>
                <div class="ai-hair-simulator-field">
                    <label for="aihs-phone" class="user-info-label">
                        <?php _e('Phone Number', 'ai-hair-simulator'); ?>
                    </label>
                    <input type="tel" id="aihs-phone" class="user-info-input" />
                </div>
                <?php endif; ?>

                <?php if (get_option('ai_hair_simulator_show_city', 1)) : ?>
                <div class="ai-hair-simulator-field">
                    <label for="aihs-city" class="user-info-label">
                        <?php _e('City', 'ai-hair-simulator'); ?>
                    </label>
                    <input type="text" id="aihs-city" class="user-info-input" />
                </div>
                <?php endif; ?>

                <?php if (get_option('ai_hair_simulator_show_age', 1)) : ?>
                <div class="ai-hair-simulator-field">
                    <label for="aihs-age" class="user-info-label">
                        <?php _e('Age', 'ai-hair-simulator'); ?>
                    </label>
                    <input type="number" id="aihs-age" class="user-info-input" min="1" max="120" />
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="ai-hair-simulator-main-grid">
            <div class="upload-section">
                <label for="image-upload" class="upload-label">
                    <?php _e('Upload Photo', 'ai-hair-simulator'); ?>
                </label>
                <input type="file" id="image-upload" accept="image/png,image/jpeg,image/jpg" />
                <p class="file-info"><?php _e('PNG, JPG, JPEG up to 3MB', 'ai-hair-simulator'); ?></p>
                <div id="image-preview" class="image-preview" style="display: none;">
                    <img id="preview-img" src="" alt="Preview" />
                </div>
            </div>

            <div class="hairstyle-section">
                <label for="hairstyle-select" class="hairstyle-label">
                    <?php _e('Select Hairstyle (Optional)', 'ai-hair-simulator'); ?>
                </label>
                <select id="hairstyle-select" class="hairstyle-select">
                    <option value="autodetect"><?php _e('Auto-detect - AI will choose the best style', 'ai-hair-simulator'); ?></option>
                    <optgroup label="<?php _e('Male Styles', 'ai-hair-simulator'); ?>">
                        <option value="BuzzCut"><?php _e('Buzz Cut - Short, uniform length all around', 'ai-hair-simulator'); ?></option>
                        <option value="UnderCut"><?php _e('Undercut - Short sides with longer top', 'ai-hair-simulator'); ?></option>
                        <option value="Pompadour"><?php _e('Pompadour - Voluminous style swept back', 'ai-hair-simulator'); ?></option>
                        <option value="SlickBack"><?php _e('Slick Back - Smooth, combed-back style', 'ai-hair-simulator'); ?></option>
                    </optgroup>
                    <optgroup label="<?php _e('Female Styles', 'ai-hair-simulator'); ?>">
                        <option value="ShortPixieWithShavedSides"><?php _e('Short Pixie - Edgy pixie with shaved sides', 'ai-hair-simulator'); ?></option>
                        <option value="ShortNeatBob"><?php _e('Short Neat Bob - Classic chin-length bob', 'ai-hair-simulator'); ?></option>
                        <option value="DoubleBun"><?php _e('Double Bun - Trendy space buns style', 'ai-hair-simulator'); ?></option>
                        <option value="Updo"><?php _e('Updo - Elegant hair styled up', 'ai-hair-simulator'); ?></option>
                    </optgroup>
                </select>
            </div>
        </div>

        <div class="ai-hair-simulator-consent">
            <label class="ai-hair-simulator-consent-label">
                <input type="checkbox" id="aihs-consent" />
                <span class="consent-text">
                    <?php _e('Yes, I\'d like to receive my simulation results and information about hair transplant options.', 'ai-hair-simulator'); ?>
                    <span class="required">*</span>
                </span>
            </label>
            <p class="consent-note"><?php _e('We respect your privacy. You can unsubscribe anytime.', 'ai-hair-simulator'); ?></p>
        </div>

        <button id="simulate-btn" class="simulate-button" disabled>
            <?php _e('Simulate', 'ai-hair-simulator'); ?>
        </button>
    </div>

    <div class="ai-hair-simulator-results" id="ai-hair-simulator-results" style="display: none;">
        <h2 class="results-title"><?php _e('Simulation Result', 'ai-hair-simulator'); ?></h2>
        <div class="results-grid">
            <div class="result-item">
                <h3><?php _e('Original', 'ai-hair-simulator'); ?></h3>
                <img id="original-image" src="" alt="Original" />
            </div>
            <div class="result-item">
                <h3><?php _e('New Hairstyle', 'ai-hair-simulator'); ?></h3>
                <div id="processed-image-container" class="processed-image-container">
                    <div class="image-loading">
                        <div class="spinner"></div>
                        <p><?php _e('Generating your new hairstyle...', 'ai-hair-simulator'); ?></p>
                    </div>
                    <img id="processed-image" src="" alt="Processed" style="display: none;" />
                </div>
                <a href="#" id="download-processed-btn" class="download-image-btn" download="new-hairstyle.jpg" style="display: none;">
                    <?php _e('Download Result', 'ai-hair-simulator'); ?>
                </a>
            </div>
        </div>
        <button id="try-another-btn" class="try-another-button">
            <?php _e('Try Another', 'ai-hair-simulator'); ?>
        </button>
    </div>
</div>

