<?php
/**
 * Plugin Name: AI Hair Simulator
 * Plugin URI: https://www.aihairtransplant.io
 * Description: AI-powered hair transplant simulator with enhanced UX and secure database
 * Version: 2.2.2
 * Author: AI Hair Transplant
 * Author URI: https://www.aihairtransplant.io
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: ai-hair-simulator
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('AI_HAIR_SIMULATOR_VERSION', '2.2.2');
define('AI_HAIR_SIMULATOR_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('AI_HAIR_SIMULATOR_PLUGIN_URL', plugin_dir_url(__FILE__));
define('AI_HAIR_SIMULATOR_PLUGIN_FILE', __FILE__);

// Include required files
require_once AI_HAIR_SIMULATOR_PLUGIN_DIR . 'includes/class-ai-hair-simulator.php';
require_once AI_HAIR_SIMULATOR_PLUGIN_DIR . 'includes/class-ai-hair-simulator-admin.php';
require_once AI_HAIR_SIMULATOR_PLUGIN_DIR . 'includes/class-ai-hair-simulator-api.php';

// Initialize the plugin
function ai_hair_simulator_init() {
    $plugin = new AI_Hair_Simulator();
    $plugin->init();
}
add_action('plugins_loaded', 'ai_hair_simulator_init');

// Add "Settings" link on Plugins page
function ai_hair_simulator_action_links($links) {
    $settings_link = '<a href="' . esc_url(admin_url('options-general.php?page=ai-hair-simulator')) . '">' .
        esc_html__('Settings', 'ai-hair-simulator') .
        '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(AI_HAIR_SIMULATOR_PLUGIN_FILE), 'ai_hair_simulator_action_links');

// Activation hook
register_activation_hook(__FILE__, array('AI_Hair_Simulator', 'activate'));

// Deactivation hook
register_deactivation_hook(__FILE__, array('AI_Hair_Simulator', 'deactivate'));

