# AI Hair Simulator WordPress Plugin

A WordPress plugin that integrates the AI Hair Simulator service into your WordPress site with activation key licensing.

## Features

- ✅ Activation key-based licensing
- ✅ Easy shortcode integration
- ✅ Admin settings page for configuration
- ✅ Real-time activation key validation
- ✅ Request tracking by website/activation key
- ✅ Beautiful, responsive UI
- ✅ Support for multiple hairstyles

## Installation

1. Upload the `wordpress-plugin` folder to your WordPress `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to Settings > AI Hair Simulator to configure the plugin

## Configuration

1. Navigate to **Settings > AI Hair Simulator** in your WordPress admin
2. Enter your **API URL** (e.g., `https://yourdomain.com`)
3. Enter your **Activation Key** (provided by the service provider)
4. Click **Validate Key** to verify your activation key is working
5. Click **Save Settings**

## Usage

### Shortcode

Add the hair simulator to any page or post using the shortcode:

```
[ai_hair_simulator]
```

### Shortcode with Custom Title

```
[ai_hair_simulator title="Try Our AI Hair Simulator"]
```

## Activation Key Management

Activation keys are managed in the Supabase database. Each key includes:

- **Activation Key**: Unique identifier
- **Company Name**: Name of the company using the plugin
- **Person Name**: Contact person name
- **Website**: Website URL where the plugin is used (use `*` for all websites)
- **Plan**: Subscription plan (basic, premium, enterprise)
- **Is Active**: Enable/disable the key
- **Activated At**: Activation date
- **Expires At**: Expiration date (optional)
- **Notes**: Additional notes

### Creating Activation Keys

You can create activation keys manually in Supabase:

```sql
INSERT INTO public.activation_keys (
    activation_key,
    company_name,
    person_name,
    website,
    plan,
    is_active,
    activated_at
) VALUES (
    'your-unique-key-here',
    'Company Name',
    'Contact Person',
    'https://example.com',
    'premium',
    true,
    NOW()
);
```

### Disabling/Enabling Keys

To disable a key:
```sql
UPDATE public.activation_keys 
SET is_active = false 
WHERE activation_key = 'your-key';
```

To enable a key:
```sql
UPDATE public.activation_keys 
SET is_active = true 
WHERE activation_key = 'your-key';
```

## Request Tracking

All requests from WordPress plugin installations are tracked in the `hair_simulations` table with:
- `activation_key_id`: Reference to the activation key used
- `source_website`: The website URL that made the request

This allows you to:
- Track usage per client/website
- Monitor API usage
- Generate reports by activation key

## File Structure

```
wordpress-plugin/
├── ai-hair-simulator.php          # Main plugin file
├── includes/
│   ├── class-ai-hair-simulator.php        # Main plugin class
│   ├── class-ai-hair-simulator-admin.php  # Admin settings
│   └── class-ai-hair-simulator-api.php   # API integration
├── templates/
│   └── frontend.php                # Frontend template
├── assets/
│   ├── css/
│   │   ├── frontend.css            # Frontend styles
│   │   └── admin.css                # Admin styles
│   └── js/
│       └── frontend.js              # Frontend JavaScript
└── README.md                        # This file
```

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- jQuery (included with WordPress)
- Valid activation key from the service provider

## Support

For support, please contact the service provider or refer to the main project documentation.

## License

GPL v2 or later

