# WordPress Plugin Installation Guide

## Quick Start

1. **Copy the plugin folder** to your WordPress installation:
   ```
   /wp-content/plugins/ai-hair-simulator/
   ```

2. **Activate the plugin** in WordPress Admin → Plugins

3. **Configure the plugin**:
   - Go to Settings → AI Hair Simulator
   - Enter your API URL (e.g., `https://yourdomain.com`)
   - Enter your Activation Key
   - Click "Validate Key" to verify
   - Save Settings

4. **Use the shortcode** on any page or post:
   ```
   [ai_hair_simulator]
   ```

## Database Setup

Before using the plugin, you need to run the Supabase migration to create the activation keys table:

1. Go to your Supabase dashboard
2. Navigate to SQL Editor
3. Run the migration file: `supabase/migrations/010_create_activation_keys_table.sql`

## Creating Activation Keys

You can create activation keys manually in Supabase. See `ACTIVATION_KEYS_EXAMPLES.sql` for example queries.

### Basic Example:

```sql
INSERT INTO public.activation_keys (
    activation_key,
    company_name,
    person_name,
    website,
    plan,
    is_active,
    activated_at
) VALUES (
    'unique-key-12345',
    'Client Company',
    'John Doe',
    'https://client-website.com',
    'premium',
    true,
    NOW()
);
```

### Wildcard Key (works on all websites):

```sql
INSERT INTO public.activation_keys (
    activation_key,
    company_name,
    person_name,
    website,
    plan,
    is_active,
    activated_at
) VALUES (
    'universal-key-xyz',
    'Universal Client',
    'Jane Smith',
    '*',  -- Wildcard for all websites
    'enterprise',
    true,
    NOW()
);
```

## Managing Keys

### Disable a key:
```sql
UPDATE public.activation_keys 
SET is_active = false 
WHERE activation_key = 'your-key';
```

### Enable a key:
```sql
UPDATE public.activation_keys 
SET is_active = true 
WHERE activation_key = 'your-key';
```

### Set expiration:
```sql
UPDATE public.activation_keys 
SET expires_at = NOW() + INTERVAL '1 year'
WHERE activation_key = 'your-key';
```

## Tracking Usage

All requests from WordPress plugins are tracked in the `hair_simulations` table with:
- `activation_key_id`: Links to the activation key
- `source_website`: The website that made the request

### View usage statistics:

```sql
SELECT 
    ak.activation_key,
    ak.company_name,
    ak.website,
    COUNT(hs.id) as total_simulations,
    COUNT(CASE WHEN hs.created_at >= NOW() - INTERVAL '30 days' THEN 1 END) as simulations_last_30_days
FROM public.activation_keys ak
LEFT JOIN public.hair_simulations hs ON hs.activation_key_id = ak.id
GROUP BY ak.id, ak.activation_key, ak.company_name, ak.website
ORDER BY total_simulations DESC;
```

## Troubleshooting

### Plugin shows "Please configure the activation key"
- Make sure you've entered the API URL and Activation Key in Settings
- Verify the activation key exists in Supabase and is active

### "Invalid activation key" error
- Check that the key exists in the database
- Verify `is_active = true`
- Check that the website URL matches (or use wildcard `*`)
- Verify expiration date hasn't passed

### API connection errors
- Verify the API URL is correct and accessible
- Check that CORS is properly configured on your API
- Ensure the API endpoints are working

## Support

For issues or questions, refer to the main project documentation or contact support.

