# AI Hair Simulator Plugin - Changelog

## Version 2.2.0 - November 19, 2025

### 🎨 Frontend UX Improvements

#### ✅ Improved Form Experience
- **Visual feedback** - Fields turn green when filled correctly
- **Clear validation** - "Please fill all required fields" message below button
- **Smooth animations** - Better button hover effects
- **Smart validation** - Real-time field validation as you type

#### ✅ Better Consent Section
- **Friendlier text** - "Yes, I'd like to receive my simulation results..."
- **Privacy note** - "We respect your privacy. You can unsubscribe anytime."
- **Better styling** - Blue highlighted box with proper checkbox alignment
- **Engaging tone** - Less warning-like, more inviting

#### ✅ Enhanced Mobile Responsivity
- **Optimized modal** - Better scrolling on mobile devices
- **iOS fixes** - 16px font size prevents auto-zoom
- **Smaller screens** - Improved layout for phones under 480px
- **Touch-friendly** - Larger tap targets for better usability

#### ✅ Cleaner Results
- **Removed download original button** - Only "Download Result" for processed image
- **Better layout** - Side-by-side comparison on desktop, stacked on mobile
- **Consistent styling** - Improved visual hierarchy

### Migration
- **No database changes** - Pure frontend update
- **Plugin**: Upload v2.2.zip (replaces v2.1)
- **Automatic**: Just replace plugin, no configuration needed

---

## Version 2.1.0 - November 19, 2025

### 🔐 Major Security & Architecture Update

#### ✅ Dedicated Clinic Database
- **New `clinic_simulations` table** - Separate, secure storage for clinic data
- **Complete data isolation** - Each clinic can ONLY access their own simulations
- **Row-Level Security (RLS)** - Database-level access control
- **Better performance** - Optimized queries and indexes

#### ✅ New API Endpoints
- `POST /api/clinic-simulations` - Create clinic simulation
- `GET /api/clinic-simulations` - Fetch clinic's simulations (with stats)
- `PATCH /api/clinic-simulations/[id]` - Update simulation
- Updated `/api/hairstylesimulator` to detect and use correct table

#### ✅ Final Gender Field Removal
- Removed from local WordPress table schema
- Complete cleanup across all systems

#### ✅ Enhanced Admin Dashboard
- Now shows statistics (total, today, this week, this month)
- Better performance fetching from dedicated table
- Cleaner data display

### Migration
- **Database**: Run migration `013_create_clinic_simulations_table.sql`
- **Plugin**: Upload v2.1.zip (replaces v2.0)
- **Automatic**: Existing data migrated automatically

---

## Version 2.0.0 - November 19, 2025

### Major Changes

#### ✅ Cloud Database Integration
- **Removed local WordPress database dependency** - All simulation data is now stored in Supabase cloud database
- **Clinic-specific data access** - Each clinic can only access their own simulations based on their activation key
- **Real-time data sync** - Simulations appear instantly in the admin dashboard from the cloud

#### ✅ Enhanced Admin Dashboard
- **Live data from Supabase** - Admin dashboard now fetches simulations directly from the cloud API
- **Download links for images** - Added "📥 Before" and "📥 After" download buttons for each simulation
- **License purchase information** - Clear notice with link to https://www.aihairtransplant.io/clinic when activation key is not entered
- **Improved table layout** - Cleaner, more organized display of simulation data

#### ✅ Improved User Experience
- **Download buttons in results** - Users can now download both original and processed images after simulation
- **Removed gender field** - Simplified form by removing gender selection from both modal and settings
- **Better button styling** - Enhanced download buttons with green color scheme

#### ✅ Security & Privacy
- **Activation key validation** - Each request validates the clinic's activation key with the cloud
- **Filtered data access** - Clinics only see simulations created with their specific activation key
- **CORS support** - Proper cross-origin headers for WordPress integration

### Technical Improvements

- Created new GET endpoint: `/api/hair-simulations` for fetching clinic-specific simulations
- Removed gender field from all data flows (frontend, backend, database)
- Simplified local logging - WordPress logging now minimal (backwards compatibility only)
- Updated plugin version to 2.0.0

### Migration Notes

**Existing users:** The plugin will continue to work with your existing activation key. No migration needed.

**Data storage:** All new simulations are stored in the cloud. Old local data (if any) remains in your WordPress database but is no longer used or displayed.

### Files Changed

- `wordpress-plugin/ai-hair-simulator.php` - Version bump to 2.0.0
- `wordpress-plugin/includes/class-ai-hair-simulator-admin.php` - Complete refactor for cloud data
- `wordpress-plugin/includes/class-ai-hair-simulator-api.php` - Simplified local logging
- `wordpress-plugin/templates/frontend.php` - Removed gender field, added download buttons
- `wordpress-plugin/assets/js/frontend.js` - Removed gender handling, added download functionality
- `wordpress-plugin/assets/css/frontend.css` - Added download button styling
- `server/api/hair-simulations/index.get.ts` - New endpoint for fetching simulations
- `server/api/hair-simulations/index.post.ts` - Removed gender from data storage

---

## Version 1.0.0 - Initial Release

- Basic plugin functionality
- Local WordPress database storage
- Activation key licensing
- Frontend simulator with modal
- Admin dashboard with basic reporting

