-- Example SQL queries for managing activation keys
-- Run these in your Supabase SQL editor

-- 1. Create a new activation key
INSERT INTO public.activation_keys (
    activation_key,
    company_name,
    person_name,
    website,
    plan,
    is_active,
    activated_at,
    notes
) VALUES (
    'demo-key-12345-abcde',  -- Replace with your unique key
    'Demo Company',
    'John Doe',
    'https://example.com',   -- Use '*' for all websites
    'premium',               -- Options: 'basic', 'premium', 'enterprise'
    true,
    NOW(),
    'Demo activation key for testing'
);

-- 2. Create a key that works on all websites (wildcard)
INSERT INTO public.activation_keys (
    activation_key,
    company_name,
    person_name,
    website,
    plan,
    is_active,
    activated_at
) VALUES (
    'universal-key-xyz',
    'Universal Client',
    'Jane Smith',
    '*',  -- Wildcard for all websites
    'enterprise',
    true,
    NOW()
);

-- 3. Disable an activation key
UPDATE public.activation_keys 
SET is_active = false,
    updated_at = NOW()
WHERE activation_key = 'demo-key-12345-abcde';

-- 4. Enable an activation key
UPDATE public.activation_keys 
SET is_active = true,
    updated_at = NOW()
WHERE activation_key = 'demo-key-12345-abcde';

-- 5. Set expiration date for a key
UPDATE public.activation_keys 
SET expires_at = NOW() + INTERVAL '1 year',
    updated_at = NOW()
WHERE activation_key = 'demo-key-12345-abcde';

-- 6. View all active keys
SELECT 
    activation_key,
    company_name,
    person_name,
    website,
    plan,
    is_active,
    activated_at,
    expires_at
FROM public.activation_keys
WHERE is_active = true
ORDER BY created_at DESC;

-- 7. View all keys (active and inactive)
SELECT * FROM public.activation_keys
ORDER BY created_at DESC;

-- 8. Find keys by company name
SELECT * FROM public.activation_keys
WHERE company_name ILIKE '%demo%'
ORDER BY created_at DESC;

-- 9. View usage statistics by activation key
SELECT 
    ak.activation_key,
    ak.company_name,
    ak.website,
    COUNT(hs.id) as total_simulations,
    COUNT(CASE WHEN hs.created_at >= NOW() - INTERVAL '30 days' THEN 1 END) as simulations_last_30_days
FROM public.activation_keys ak
LEFT JOIN public.hair_simulations hs ON hs.activation_key_id = ak.id
GROUP BY ak.id, ak.activation_key, ak.company_name, ak.website
ORDER BY total_simulations DESC;

-- 10. Delete an activation key (use with caution)
-- DELETE FROM public.activation_keys WHERE activation_key = 'demo-key-12345-abcde';

